// VERSION :Scilab:6.0.1
// OS : WINDOWS 10
// CAPTION:Sampling Theorem
clc ;
clear all;
t =0:0.01:100;
f =0.02;
x=sin(2*%pi*f*t);
subplot(2,2,1);
plot (t,x);
xgrid(4,1,7);
xlabel("Time");
ylabel("Amplitude");
title ("CT Signal");
// Sampling frequency less than twices of input signal frequency
fs1 =0.002;
n =0:0.1:100;
x1=sin (2*%pi*f*n/fs1 );
subplot(2,2,2);
plot2d3(n,x1,style=[color("blue")]);
xlabel("n");
ylabel("Amplitude");
xgrid(4,1,7);
title( "fs<2f");
// Sampling frequency is equal to twices of input signal frequency
fs2 =0.04;
x2= sin (2*%pi*f*n/fs2);
subplot(2,2,3);
plot2d3(n,x2,style=[color("blue")]);
xlabel("n");
ylabel("Amplitude");
xgrid(4,1,7);
title ("Sampling fs=2f");
//Sampling frequency is greater than twice of input signal frequency
fs3 =0.4;
x3= sin (2*%pi*f*n/fs3 );
subplot (2,2,4);
plot2d3 (n,x3,style=[color("blue")]);
xlabel("n");
ylabel("Amplitude");
xgrid(4,1,7);
title ("fs>2f");
